class SyntaxHighlight {
   
    static $tokens = array();// This array will be filled from the regexp-callback
    public static function process($s) {
        $s = htmlspecialchars($s);
        // Workaround for escaped backslashes
        $s = str_replace('\\\\','\\\\&lt;e&gt;', $s); 
        $regexp = array(
            // Punctuations
            '/([\-\!\%\^\*\(\)\+\|\~\=\`\{\}\[\]\:\"\'&lt;&gt;\?\,\.\/]+)/'
            =&gt; '&lt;span class="P"&gt;$1&lt;/span&gt;',
            // Numbers (also look for Hex)
            '/(?&lt;!\w)(
                (0x|\#)[\da-f]+|
                \d+|
                \d+(px|em|cm|mm|rem|s|\%)
            )(?!\w)/ix'
            =&gt; '&lt;span class="N"&gt;$1&lt;/span&gt;',
            // Make the bold assumption that an
            // all uppercase word has a special meaning
            '/(?&lt;!\w|&gt;|\#)(
                [A-Z_0-9]{2,}
            )(?!\w)/x'
            =&gt; '&lt;span class="D"&gt;$1&lt;/span&gt;',
            // Keywords
            '/(?&lt;!\w|\$|\%|\@|&gt;)(
                and|or|xor|for|do|while|foreach|as|return|die|exit|if|then|else|
                elseif|new|delete|try|throw|catch|finally|class|function|string|
                array|object|resource|var|bool|boolean|int|integer|float|double|
                real|string|array|global|const|static|public|private|protected|
                published|extends|switch|true|false|null|void|this|self|struct|
                char|signed|unsigned|short|long
            )(?!\w|=")/ix'
            =&gt; '&lt;span class="K"&gt;$1&lt;/span&gt;',
            // PHP/Perl-Style Vars: $var, %var, @var
            '/(?&lt;!\w)(
                (\$|\%|\@)(\-&gt;|\w)+
            )(?!\w)/ix'
            =&gt; '&lt;span class="V"&gt;$1&lt;/span&gt;'
        );      
	
        $s = preg_replace_callback( '/(
                \/\*.*?\*\/|
                \/\/.*?\n|
                \#.[^a-fA-F0-9]+?\n|
                \&lt;\!\-\-[\s\S]+\-\-\&gt;|
                (?&lt;!\\\)&amp;quot;.*?(?&lt;!\\\)&amp;quot;|
                (?&lt;!\\\)\'(.*?)(?&lt;!\\\)\'
            )/isx' , array('SyntaxHighlight', 'replaceId'),$s);
			
        $s = preg_replace(array_keys($regexp), array_values($regexp), $s);
        // Paste the comments and strings back in again
        $s = str_replace(array_keys(SyntaxHighlight::$tokens), array_values(SyntaxHighlight::$tokens), $s);
        // Delete the "Escaped Backslash Workaround Token" (TM)
        // and replace tabs with four spaces.
        $s = str_replace(array('&lt;e&gt;', "\t"), array('', '    '), $s);
        return '&lt;pre&gt;'.$s.'&lt;/pre&gt;' ;
    }
    // Regexp-Callback to replace every comment or string with a uniqid and save
    // the matched text in an array
    // This way, strings and comments will be stripped out and wont be processed
    // by the other expressions searching for keywords etc.
     static function replaceId($match) {
        $id = "##r" . uniqid() . "##";
	
        // String or Comment?
        if(substr($match[1], 0, 2) == '//' || substr($match[1], 0, 2) == '/*' || substr($match[1], 0, 2) == '##' || substr($match[1], 0, 7) == '&lt;!--') {
            SyntaxHighlight::$tokens[$id] = '&lt;span class="C"&gt;' . $match[1] . '&lt;/span&gt;';
        } else {
           SyntaxHighlight::$tokens[$id] = '&lt;span class="S"&gt;' . $match[1] . '&lt;/span&gt;';
        }
		
        return $id;
    }
}

echo SyntaxHighlight::process( $your_code );